/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.impl;

import java.util.Locale;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.i18n.LocaleResolver;
import org.noear.solon.i18n.LocaleUtil;

public class LocaleResolverHeader
implements LocaleResolver {
    private String headerName = "Accept-Language";

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public Locale getLocale(Context ctx) {
        if (ctx.getLocale() == null) {
            String lang = ctx.header(this.headerName);
            if (Utils.isEmpty((String)lang)) {
                ctx.setLocale(Locale.getDefault());
            } else {
                if (lang.contains(",")) {
                    lang = lang.split(",")[0];
                }
                ctx.setLocale(LocaleUtil.toLocale(lang));
            }
        }
        return ctx.getLocale();
    }

    @Override
    public void setLocale(Context ctx, Locale locale) {
        ctx.headerSet(this.headerName, locale.getLanguage());
        ctx.setLocale(locale);
    }
}

