/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.impl;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.i18n.I18nBundle;

public class I18nBundleLocal
implements I18nBundle {
    Properties bundle;
    String bundleName;
    Locale locale;
    Map<String, String> map;

    public I18nBundleLocal(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Solon.cfg().locale();
        }
        this.locale = locale;
        this.bundleName = bundleName;
        String bundleName2 = bundleName.replace(".", "/");
        this.bundle = this.loadProperties(bundleName2, new String[]{".properties", ".yml"});
        if (this.bundle == null) {
            this.bundle = new Properties();
        }
        Properties tmp = null;
        tmp = this.loadProperties(bundleName2 + "_" + locale.getLanguage(), new String[]{".properties", ".yml"});
        if (tmp != null) {
            tmp.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.bundle.put(k, v)));
        }
        if ((tmp = this.loadProperties(bundleName2 + "_" + locale, new String[]{".properties", ".yml"})) != null) {
            tmp.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.bundle.put(k, v)));
        }
    }

    @Override
    public synchronized Map<String, String> toMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, String>();
            for (Object k : this.bundle.keySet()) {
                String key = (String)k;
                this.map.put(key, this.get(key));
            }
        }
        return this.map;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public String get(String key) {
        String tmp = this.bundle.getProperty(key);
        if (tmp == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.bundleName + ", key " + key, this.getClass().getName(), key);
        }
        return tmp;
    }

    private Properties loadProperties(String path, String[] extensions) {
        Properties tmp = null;
        for (String ext : extensions) {
            tmp = Utils.loadProperties((String)(path + ext));
            if (tmp != null) break;
        }
        return tmp;
    }
}

