/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.appender.ConsoleAppender;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderManager {
    private static Map<String, AppenderHolder> appenderMap = new HashMap<String, AppenderHolder>();
    private static List<AppenderHolder> appenderValues = new ArrayList<AppenderHolder>();

    public static void init() {
    }

    public static synchronized void register(String name, Appender appender) {
        AppenderManager.registerDo(name, appender, false);
        LogUtil.global().infoAsync("Logging: LogAppender registered from the " + appender.getClass().getTypeName() + "#" + name);
    }

    private static void registerDo(String name, Appender appender, boolean printed) {
        if (!appenderMap.containsKey(name)) {
            AppenderHolder holder = new AppenderHolder(name, appender, printed);
            appenderMap.put(name, holder);
            appenderValues.add(holder);
        }
    }

    public static AppenderHolder get(String name) {
        return appenderMap.get(name);
    }

    public static int count() {
        return appenderValues.size();
    }

    public static void append(LogEvent logEvent) {
        int len = appenderValues.size();
        for (int i = 0; i < len; ++i) {
            AppenderHolder appender = appenderValues.get(i);
            appender.append(logEvent);
        }
    }

    public static void appendNotPrinted(LogEvent logEvent) {
        int len = appenderValues.size();
        for (int i = 0; i < len; ++i) {
            AppenderHolder appender = appenderValues.get(i);
            if (appender.printed()) continue;
            appender.append(logEvent);
        }
    }

    public static void stop() {
        for (AppenderHolder appender : appenderValues) {
            appender.stop();
        }
    }

    static {
        AppenderManager.registerDo("console", new ConsoleAppender(), true);
    }
}

