/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.LogConsoleAppender;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderManager
implements Appender {
    private static AppenderManager instance;
    protected Map<String, Appender> appenderMap = new LinkedHashMap<String, Appender>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppenderManager getInstance() {
        if (instance != null) return instance;
        Class<AppenderManager> clazz = AppenderManager.class;
        synchronized (AppenderManager.class) {
            if (instance != null) return instance;
            instance = new AppenderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(Appender appender) {
        this.appenderMap.putIfAbsent(appender.getName(), appender);
        PrintUtil.info((String)"Logging", (Object)("LogAppender registered from the " + appender.getClass().getTypeName() + "#" + appender.getName()));
    }

    private AppenderManager() {
        this.register(new LogConsoleAppender());
    }

    @Override
    public String getName() {
        return "proxy";
    }

    @Override
    public void append(LogEvent logEvent) {
        for (Appender appender : this.appenderMap.values()) {
            appender.append(logEvent);
        }
    }
}

