/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.appender;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.noear.solon.logging.event.AppenderBase;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public class AppenderSimple
extends AppenderBase {
    protected boolean allowAppend() {
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        if (!this.allowAppend()) {
            return;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(new Date(logEvent.getTimeStamp()).toInstant(), ZoneId.systemDefault());
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(logEvent.getLevel().name()).append("] ");
        buf.append(dateTime.toString()).append(" ");
        buf.append("[-").append(Thread.currentThread().getName()).append("]");
        if (logEvent.getMetainfo() != null) {
            logEvent.getMetainfo().forEach((k, v) -> buf.append("[@").append((String)k).append(":").append((String)v).append("]"));
        }
        buf.append(" ").append(logEvent.getLoggerName());
        buf.append("#").append(this.getName());
        buf.append(": ");
        this.appendDo(logEvent.getLevel(), buf.toString(), logEvent.getContent());
    }

    protected void appendDo(Level level, String title, Object content) {
        System.out.println(title);
        System.out.println(content);
    }
}

