/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.appender.ConsoleAppender;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderManager {
    private static AppenderManager instance;
    protected Map<String, AppenderHolder> appenderMap = new LinkedHashMap<String, AppenderHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppenderManager getInstance() {
        if (instance != null) return instance;
        Class<AppenderManager> clazz = AppenderManager.class;
        synchronized (AppenderManager.class) {
            if (instance != null) return instance;
            instance = new AppenderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AppenderManager() {
        this.register("console", new ConsoleAppender());
    }

    public void register(String name, Appender appender) {
        this.appenderMap.putIfAbsent(name, new AppenderHolder(name, appender));
        PrintUtil.info((String)"Logging", (Object)("LogAppender registered from the " + appender.getClass().getTypeName() + "#" + name));
    }

    public void append(LogEvent logEvent) {
        for (AppenderHolder appender : this.appenderMap.values()) {
            appender.append(logEvent);
        }
    }

    public void stop() {
        for (AppenderHolder appender : this.appenderMap.values()) {
            appender.stop();
        }
    }
}

