/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.appender.ConsoleAppender;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderManager {
    private static Map<String, AppenderHolder> appenderMap = new ConcurrentHashMap<String, AppenderHolder>();
    private static List<AppenderHolder> appenderValues = new ArrayList<AppenderHolder>();

    public static void init() {
    }

    public static void register(String name, Appender appender) {
        AppenderManager.registerDo(name, appender, false);
    }

    private static void registerDo(String name, Appender appender, boolean printed) {
        appenderMap.computeIfAbsent(name, k -> {
            AppenderHolder holder = new AppenderHolder(name, appender, printed);
            appenderValues.add(holder);
            return holder;
        });
    }

    public static AppenderHolder get(String name) {
        return appenderMap.get(name);
    }

    public static int count() {
        return appenderValues.size();
    }

    public static void append(LogEvent logEvent) {
        int len = appenderValues.size();
        for (int i = 0; i < len; ++i) {
            AppenderHolder appender = appenderValues.get(i);
            appender.append(logEvent);
        }
    }

    public static void appendNotPrinted(LogEvent logEvent) {
        int len = appenderValues.size();
        for (int i = 0; i < len; ++i) {
            AppenderHolder appender = appenderValues.get(i);
            if (appender.printed()) continue;
            appender.append(logEvent);
        }
    }

    public static void stop() {
        for (AppenderHolder appender : appenderValues) {
            appender.stop();
        }
    }

    static {
        AppenderManager.registerDo("console", new ConsoleAppender(), true);
    }
}

