/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.apt.util;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.noear.solon.proxy.apt.holder.ParamElementHolder;
import org.noear.solon.proxy.apt.util.MethodUtil;
import org.noear.solon.proxy.apt.util.TypeNameUtil;

public class ClassFileBuilder {
    public JavaFile build(ProcessingEnvironment env, TypeElement typeElement) {
        PackageElement packageElement = env.getElementUtils().getPackageOf(typeElement);
        String packageName = packageElement.getQualifiedName().toString();
        String className = ClassFileBuilder.getClassName(typeElement, packageName);
        ClassName supperClassName = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        String proxyClassName = className + "$$SolonAptProxy";
        Map<String, ExecutableElement> methodAll = MethodUtil.findMethodAll(typeElement);
        TypeSpec.Builder proxyTypeBuilder = TypeSpec.classBuilder((String)proxyClassName).superclass((TypeName)supperClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.addConstructor(proxyTypeBuilder, typeElement, proxyClassName);
        this.addMethodAll(proxyTypeBuilder, methodAll);
        this.addStaticBlock(proxyTypeBuilder, packageName, className, methodAll);
        TypeSpec proxyType = proxyTypeBuilder.build();
        return JavaFile.builder((String)packageName, (TypeSpec)proxyType).build();
    }

    private void addConstructor(TypeSpec.Builder proxyTypeBuilder, TypeElement typeElement, String proxyClassName) {
        proxyTypeBuilder.addField(InvocationHandler.class, "handler", new Modifier[]{Modifier.PRIVATE});
        MethodSpec.Builder methodBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(InvocationHandler.class, "handler", new Modifier[0]);
        methodBuilder.addStatement("this.handler = handler", new Object[0]);
        proxyTypeBuilder.addMethod(methodBuilder.build());
    }

    private void addStaticBlock(TypeSpec.Builder proxyTypeBuilder, String packageName, String className, Map<String, ExecutableElement> methodAll) {
        int methodIndex = 0;
        StringBuilder codeBuilder = new StringBuilder(150);
        codeBuilder.append("try {\n");
        codeBuilder.append("  Class<?> clazz = $T.class;\n\n");
        for (ExecutableElement methodElement : methodAll.values()) {
            if (!MethodUtil.allowMethod(methodElement)) continue;
            String methodFieldName = "  method" + methodIndex;
            codeBuilder.append(methodFieldName).append("=clazz.getMethod(\"").append(methodElement.getSimpleName()).append("\"");
            for (VariableElement variableElement : methodElement.getParameters()) {
                if (variableElement instanceof ParamElementHolder) {
                    ParamElementHolder p0x = (ParamElementHolder)variableElement;
                    TypeMirror p1 = p0x.getReal().asType();
                    String p1Name = p1.toString();
                    int p1NameIdx = p1Name.indexOf("<");
                    if (p1NameIdx > 0) {
                        p1Name = p1Name.substring(0, p1NameIdx);
                    }
                    if (p1 instanceof TypeVariable) {
                        codeBuilder.append(",Object.class");
                        continue;
                    }
                    codeBuilder.append(",").append(p1Name).append(".class");
                    continue;
                }
                TypeMirror p1 = variableElement.asType();
                String p1Name = p1.toString();
                int p1NameIdx = p1Name.indexOf("<");
                if (p1NameIdx > 0) {
                    p1Name = p1Name.substring(0, p1NameIdx);
                }
                codeBuilder.append(",").append(p1Name).append(".class");
            }
            codeBuilder.append(");\n");
            ++methodIndex;
        }
        codeBuilder.append("} catch (Throwable e) {\n  throw new IllegalStateException(e);\n}\n");
        CodeBlock codeBlock = CodeBlock.of((String)codeBuilder.toString(), (Object[])new Object[]{ClassName.get((String)packageName, (String)className, (String[])new String[0])});
        proxyTypeBuilder.addStaticBlock(codeBlock);
    }

    private void addMethodAll(TypeSpec.Builder proxyTypeBuilder, Map<String, ExecutableElement> methodAll) {
        int methodIndex = 0;
        for (ExecutableElement e : methodAll.values()) {
            methodIndex = this.addMethod(proxyTypeBuilder, e, methodIndex);
        }
    }

    private int addMethod(TypeSpec.Builder proxyTypeBuilder, ExecutableElement methodElement, int methodIndex) {
        if (!MethodUtil.allowMethod(methodElement)) {
            return methodIndex;
        }
        String methodFieldName = "method" + methodIndex;
        proxyTypeBuilder.addField(Method.class, methodFieldName, new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        TypeMirror returnType = methodElement.getReturnType();
        TypeName returnTypeName = TypeNameUtil.getTypeName(returnType);
        StringBuilder codeBuilder = new StringBuilder(150);
        boolean isPublic = methodElement.getModifiers().contains((Object)Modifier.PUBLIC);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodElement.getSimpleName().toString()).addModifiers(new Modifier[]{isPublic ? Modifier.PUBLIC : Modifier.PROTECTED}).addAnnotation(Override.class).returns(returnTypeName);
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            methodBuilder.addException(TypeName.get((TypeMirror)typeMirror));
        }
        for (TypeParameterElement typeParameterElement : methodElement.getTypeParameters()) {
            if (typeParameterElement.asType() instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)typeParameterElement.asType();
                methodBuilder.addTypeVariable(TypeVariableName.get((TypeVariable)tv));
                continue;
            }
            methodBuilder.addTypeVariable(TypeVariableName.get((String)typeParameterElement.getSimpleName().toString()));
        }
        codeBuilder.append("handler.invoke(this, ").append(methodFieldName).append(", ").append("new Object[]{");
        for (VariableElement variableElement : methodElement.getParameters()) {
            TypeMirror pet = variableElement.asType();
            TypeName paramType = TypeNameUtil.getTypeName(pet);
            String paramName = variableElement.getSimpleName().toString();
            methodBuilder.addParameter(paramType, paramName, new Modifier[0]);
            codeBuilder.append(paramName).append(",");
        }
        if (codeBuilder.charAt(codeBuilder.length() - 1) == ',') {
            codeBuilder.setLength(codeBuilder.length() - 1);
        }
        codeBuilder.append("});");
        if (methodElement.getReturnType().getKind() == TypeKind.VOID) {
            codeBuilder.insert(0, "try { \n  ");
            codeBuilder.append("\n} catch (RuntimeException _ex) {\n  throw _ex;\n} catch (Throwable _ex) {\n  throw new RuntimeException(_ex);\n}\n");
            methodBuilder.addCode(codeBuilder.toString(), new Object[0]);
        } else {
            codeBuilder.insert(0, "try { \n  return (" + returnType + ")");
            codeBuilder.append("\n} catch (RuntimeException _ex) {\n  throw _ex;\n} catch (Throwable _ex) {\n  throw new RuntimeException(_ex);\n}\n");
            methodBuilder.addCode(codeBuilder.toString(), new Object[0]);
        }
        proxyTypeBuilder.addMethod(methodBuilder.build());
        return ++methodIndex;
    }

    public static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }
}

