/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.apt.util;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.noear.solon.proxy.apt.holder.MethodElementHolder;

public class MethodUtil {
    public static boolean allowMethod(Element element) {
        return !element.getModifiers().contains((Object)Modifier.STATIC) && !element.getModifiers().contains((Object)Modifier.FINAL) && !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public static String buildMethodKey(ExecutableElement method) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getSimpleName().toString());
        buf.append("(");
        for (VariableElement variableElement : method.getParameters()) {
            TypeMirror pet = variableElement.asType();
            buf.append(pet.toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public static Map<String, ExecutableElement> findMethodAll(TypeElement type) {
        LinkedHashMap<String, ExecutableElement> methodAll = new LinkedHashMap<String, ExecutableElement>();
        for (Element element : type.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !MethodUtil.allowMethod(element)) continue;
            ExecutableElement method = (ExecutableElement)element;
            String methodKey = MethodUtil.buildMethodKey(method);
            methodAll.put(methodKey, method);
        }
        TypeMirror origin = type.getSuperclass();
        while (origin.getKind() == TypeKind.DECLARED && !"java.lang.Object".equals(origin.toString())) {
            DeclaredType declaredType = (DeclaredType)origin;
            TypeElement originElement = (TypeElement)declaredType.asElement();
            LinkedHashMap<String, TypeMirror> gtArgMap = new LinkedHashMap<String, TypeMirror>();
            int n = declaredType.getTypeArguments().size();
            for (int i = 0; i < n; ++i) {
                TypeParameterElement gtKey = originElement.getTypeParameters().get(i);
                TypeMirror gtVal = declaredType.getTypeArguments().get(i);
                gtArgMap.put(gtKey.toString(), gtVal);
            }
            for (Element element : originElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || !MethodUtil.allowMethod(element)) continue;
                MethodElementHolder method = new MethodElementHolder((ExecutableElement)element, gtArgMap);
                String methodKey = MethodUtil.buildMethodKey(method);
                methodAll.put(methodKey, method);
            }
            origin = originElement.getSuperclass();
        }
        return methodAll;
    }
}

