/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.apt;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.noear.solon.proxy.apt.util.ClassFileBuilder;

public abstract class AbstractAptProxyProcessor
extends AbstractProcessor {
    private ClassFileBuilder classFileBuilder = new ClassFileBuilder();
    private final Map<String, Class<? extends Annotation>> supportedAnnoMap = new LinkedHashMap<String, Class<? extends Annotation>>();

    public AbstractAptProxyProcessor() {
        this.initSupportedAnnotation();
    }

    protected void addSupportedAnnotation(Class<? extends Annotation> annoClz) {
        this.supportedAnnoMap.put(annoClz.getCanonicalName(), annoClz);
    }

    protected abstract void initSupportedAnnotation();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnoMap.keySet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!annotations.isEmpty()) {
            try {
                for (TypeElement typeElement : annotations) {
                    String annoKey = typeElement.asType().toString();
                    Class<? extends Annotation> annoType = this.supportedAnnoMap.get(annoKey);
                    if (annoType == null) continue;
                    this.generateCode(roundEnv.getElementsAnnotatedWith(annoType));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void generateCode(Set<? extends Element> elements) throws IOException {
        if (elements == null) {
            return;
        }
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.assertElement(typeElement);
            JavaFile javaFile = this.classFileBuilder.build(this.processingEnv, typeElement);
            javaFile.writeTo(this.processingEnv.getFiler());
        }
    }

    private void assertElement(TypeElement typeElement) throws IllegalStateException {
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalStateException("Abstract classes are not supported as proxy components");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new IllegalStateException("Final classes are not supported as proxy components");
        }
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new IllegalStateException("Not public classes are not supported as proxy components");
        }
        if (typeElement.getTypeParameters().size() > 0) {
            throw new IllegalStateException("Generic type classes are not supported as proxy components");
        }
    }
}

