/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.core.AopContext;
import org.noear.solon.proxy.asm.AsmClassCodeBuilder;
import org.noear.solon.proxy.asm.AsmProxyClassLoader;

public class AsmProxy {
    public static final int ASM_VERSION = 589824;
    public static final String PROXY_CLASSNAME_SUFFIX = "$$SolonAsmProxy";
    private static final String METHOD_SETTER = "setInvocationHandler";
    private static final Map<String, Class<?>> proxyClassCache = new HashMap();

    private static void saveProxyClassCache(ClassLoader classLoader, Class<?> targetClass, Class<?> proxyClass) {
        String key = classLoader.toString() + "_" + targetClass.getName();
        proxyClassCache.put(key, proxyClass);
    }

    private static Class<?> getProxyClassCache(ClassLoader classLoader, Class<?> targetClass) {
        String key = classLoader.toString() + "_" + targetClass.getName();
        return proxyClassCache.get(key);
    }

    public static Object newProxyInstance(AopContext context, InvocationHandler invocationHandler, Class<?> targetClass) {
        try {
            Constructor<?> constructor = targetClass.getConstructor(new Class[0]);
            Object[] constructorParam = new Object[]{};
            return AsmProxy.newProxyInstance(context, invocationHandler, targetClass, constructor, constructorParam);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to generate the proxy instance: " + targetClass.getName(), e);
        }
    }

    public static Object newProxyInstance(AopContext context, InvocationHandler invocationHandler, Class<?> targetClass, Constructor<?> targetConstructor, Object ... targetParam) {
        if (targetClass == null || invocationHandler == null) {
            throw new IllegalArgumentException("argument is null");
        }
        AsmProxyClassLoader classLoader = (AsmProxyClassLoader)context.getAttrs().get(AsmProxyClassLoader.class);
        if (classLoader == null) {
            classLoader = new AsmProxyClassLoader(context.getClassLoader());
            context.getAttrs().put(AsmProxyClassLoader.class, classLoader);
        }
        try {
            Class<?> proxyClass = AsmProxy.getProxyClassCache(classLoader, targetClass);
            if (proxyClass == null) {
                proxyClass = AsmClassCodeBuilder.build(targetClass, classLoader);
                AsmProxy.saveProxyClassCache(classLoader, targetClass, proxyClass);
            }
            return AsmProxy.newInstance(proxyClass, invocationHandler, targetConstructor, targetParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object newInstance(Class<?> proxyClass, InvocationHandler invocationHandler, Constructor<?> targetConstructor, Object ... targetParam) throws Exception {
        Class<?>[] parameterTypes = targetConstructor.getParameterTypes();
        Constructor<?> constructor = proxyClass.getConstructor(parameterTypes);
        Object instance = constructor.newInstance(targetParam);
        Method setterMethod = proxyClass.getDeclaredMethod(METHOD_SETTER, InvocationHandler.class);
        setterMethod.setAccessible(true);
        setterMethod.invoke(instance, invocationHandler);
        return instance;
    }
}

