/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.proxy.BeanProxy;

public class ProxyUtil {
    private static Set<Class<?>> tryAttachCached = new HashSet();

    public static boolean binding(BeanWrap bw, String name, boolean typed) {
        if (bw.proxy() instanceof ProxyUtil) {
            return false;
        }
        if (bw.clz().isInterface()) {
            throw new IllegalStateException("Interfaces are not supported as proxy components: " + bw.clz().getName());
        }
        int modifier = bw.clz().getModifiers();
        if (Modifier.isFinal(modifier)) {
            throw new IllegalStateException("Final classes are not supported as proxy components: " + bw.clz().getName());
        }
        if (Modifier.isAbstract(modifier)) {
            throw new IllegalStateException("Abstract classes are not supported as proxy components: " + bw.clz().getName());
        }
        if (!Modifier.isPublic(modifier)) {
            throw new IllegalStateException("Not public classes are not supported as proxy components: " + bw.clz().getName());
        }
        bw.proxySet((BeanWrap.Proxy)BeanProxy.getGlobal());
        bw.context().beanRegister(bw, name, typed);
        return true;
    }

    public static boolean binding(BeanWrap bw) {
        return ProxyUtil.binding(bw, "", false);
    }

    public static void attach(AopContext aopContext, Class<?> clz, InvocationHandler handler) {
        if (clz.isAnnotation() || clz.isInterface() || clz.isEnum() || clz.isPrimitive()) {
            return;
        }
        if (tryAttachCached.contains(clz)) {
            return;
        }
        tryAttachCached.add(clz);
        aopContext.wrapAndPut(clz).proxySet((BeanWrap.Proxy)new BeanProxy(handler));
    }

    public static void attachByScan(AopContext aopContext, String basePackage, InvocationHandler handler) {
        ProxyUtil.attachByScan(aopContext, basePackage, null, handler);
    }

    public static void attachByScan(AopContext aopContext, String basePackage, Predicate<String> filter, InvocationHandler handler) {
        if (Utils.isEmpty((String)basePackage)) {
            return;
        }
        if (aopContext == null) {
            return;
        }
        if (filter == null) {
            filter = s -> true;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan((ClassLoader)aopContext.getClassLoader(), (String)dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).filter(filter).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class clz = ClassUtil.loadClass((ClassLoader)aopContext.getClassLoader(), (String)className.replace("/", "."));
            if (clz != null) {
                ProxyUtil.attach(aopContext, clz, handler);
            }
        });
    }
}

