/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.proxy.aot.AotProxy;
import org.noear.solon.proxy.asm.AsmProxy;

public class BeanInvocationHandler
implements InvocationHandler {
    private Object target;
    private Object proxy;
    private InvocationHandler handler;
    private final AopContext context;

    public BeanInvocationHandler(AopContext context, Object bean, InvocationHandler handler) {
        this(context, bean.getClass(), bean, handler);
    }

    public BeanInvocationHandler(AopContext context, Class<?> clazz, Object target, InvocationHandler handler) {
        this.context = context;
        this.target = target;
        this.handler = handler;
        this.proxy = AotProxy.newProxyInstance(context, this, clazz);
        if (this.proxy == null) {
            this.proxy = AsmProxy.newProxyInstance(context, this, clazz);
        }
        if (Solon.cfg().isDebugMode() && this.proxy != null) {
            LogUtil.global().trace("proxy class:" + this.proxy.getClass().getName());
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.handler == null) {
            method.setAccessible(true);
            Object result = this.context.methodGet(method).invokeByAspect(this.target, args);
            return result;
        }
        return this.handler.invoke(this.target, method, args);
    }
}

