/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.integration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.wrap.ClassWrap;

public class UnsupportedUtil {
    public static void check(Class<?> clz, AopContext context, Annotation anno) {
        UnsupportedUtil.beanShapeCheck(clz, "@" + anno.annotationType().getSimpleName());
        UnsupportedUtil.beanExtractCheck(clz, context);
    }

    private static void beahShapeHint(String target, String annoName, Class<?> clz) {
        LogUtil.global().warn("'" + target + "' not support " + annoName + " annotations, please use @Component: " + clz.getName());
    }

    private static void beanExtractHint(String target, Class<?> clz) {
        LogUtil.global().warn("The '@" + target + "' function supports only class @Component annotations: " + clz.getName());
    }

    private static void beanShapeCheck(Class<?> clz, String annoName) {
        if (LifecycleBean.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("LifecycleBean", annoName, clz);
        }
        if (EventListener.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("EventListener", annoName, clz);
        }
        if (LoadBalance.Factory.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("LoadBalance.Factory", annoName, clz);
        }
        if (Handler.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("Handler", annoName, clz);
        }
        if (Filter.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("Filter", annoName, clz);
        }
        if (RouterInterceptor.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("RouterInterceptor", annoName, clz);
        }
        if (ActionReturnHandler.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("ActionReturnHandler", annoName, clz);
        }
        if (ActionExecuteHandler.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("ActionExecuteHandler", annoName, clz);
        }
        if (Converter.class.isAssignableFrom(clz)) {
            UnsupportedUtil.beahShapeHint("Converter", annoName, clz);
        }
    }

    private static void beanExtractCheck(Class<?> clz, AopContext context) {
        ClassWrap clzWrap = ClassWrap.get(clz);
        for (Method m : clzWrap.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                if (!context.beanExtractorHas(a.annotationType())) continue;
                UnsupportedUtil.beanExtractHint(a.annotationType().getSimpleName(), clz);
            }
        }
    }
}

