/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.schedule.integration;

import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.schedule.JobManager;
import org.noear.solon.schedule.annotation.Scheduled;
import org.noear.solon.schedule.integration.MethodRunnable;

public class ScheduledBeanBuilder
implements BeanBuilder<Scheduled>,
BeanExtractor<Scheduled> {
    public void doBuild(Class<?> clz, BeanWrap bw, Scheduled anno) throws Throwable {
        if (Runnable.class.isAssignableFrom(clz)) {
            String name = anno.name();
            if (Utils.isEmpty((String)name)) {
                name = clz.getName();
            }
            if (anno.fixedRate() > 0L) {
                JobManager.add(name, anno.fixedRate(), anno.fixedDelay(), anno.concurrent(), (Runnable)bw.raw());
            } else {
                JobManager.add(name, anno.cron(), anno.zone(), anno.concurrent(), (Runnable)bw.raw());
            }
        }
    }

    public void doExtract(BeanWrap bw, Method method, Scheduled anno) throws Throwable {
        if (method.getParameterCount() > 0) {
            throw new IllegalStateException("Scheduling local job not supports parameter!");
        }
        String name = anno.name();
        if (Utils.isEmpty((String)name)) {
            name = bw.clz().getName() + "::" + method.getName();
        }
        MethodRunnable runnable = new MethodRunnable(bw.raw(), method);
        if (anno.fixedRate() > 0L) {
            JobManager.add(name, anno.fixedRate(), anno.fixedDelay(), anno.concurrent(), (Runnable)runnable);
        } else {
            JobManager.add(name, anno.cron(), anno.zone(), anno.concurrent(), (Runnable)runnable);
        }
    }
}

