/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.schedule;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.schedule.JobEntity;
import org.noear.solon.schedule.cron.CronExpressionPlus;
import org.noear.solon.schedule.cron.CronUtils;

public class JobManager {
    private static List<JobEntity> jobEntityList = new ArrayList<JobEntity>();

    public static void add(String name, String cron, boolean concurrent, Runnable runnable) throws ParseException {
        CronExpressionPlus cronX = CronUtils.get(cron);
        jobEntityList.add(new JobEntity(name, cronX, 0L, 0L, concurrent, runnable));
    }

    public static void add(String name, String cron, String zone, boolean concurrent, Runnable runnable) throws ParseException {
        CronExpressionPlus cronX = CronUtils.get(cron);
        if (Utils.isNotEmpty((String)zone)) {
            cronX.setTimeZone(TimeZone.getTimeZone(zone));
        }
        jobEntityList.add(new JobEntity(name, cronX, 0L, 0L, concurrent, runnable));
    }

    public static void add(String name, long fixedRate, boolean concurrent, Runnable runnable) {
        jobEntityList.add(new JobEntity(name, null, fixedRate, 0L, concurrent, runnable));
    }

    public static void add(String name, long fixedRate, long fixedDelay, boolean concurrent, Runnable runnable) {
        jobEntityList.add(new JobEntity(name, null, fixedRate, fixedDelay, concurrent, runnable));
    }

    public static void start() {
        for (JobEntity job : jobEntityList) {
            job.start();
        }
    }

    public static void stop() {
        for (JobEntity job : jobEntityList) {
            job.cancel();
        }
    }
}

