/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.schedule.integration;

import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.schedule.JobManager;
import org.noear.solon.schedule.MethodRunnable;
import org.noear.solon.schedule.annotation.EnableScheduling;
import org.noear.solon.schedule.annotation.Scheduled;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        if (app.source().getAnnotation(EnableScheduling.class) == null) {
            return;
        }
        Aop.context().beanBuilderAdd(Scheduled.class, (clz, bw, anno) -> {
            if (Runnable.class.isAssignableFrom(clz)) {
                String name = Utils.annoAlias((String)anno.name(), (String)clz.getSimpleName());
                if (anno.fixedRate() > 0L) {
                    JobManager.add(name, anno.fixedRate(), anno.fixedDelay(), anno.concurrent(), (Runnable)bw.raw());
                } else {
                    JobManager.add(name, anno.cron(), anno.zone(), anno.concurrent(), (Runnable)bw.raw());
                }
            }
        });
        Aop.context().beanExtractorAdd(Scheduled.class, (bw, method, anno) -> {
            MethodRunnable runnable = new MethodRunnable(bw.raw(), method);
            String name = Utils.annoAlias((String)anno.name(), (String)method.getName());
            if (anno.fixedRate() > 0L) {
                JobManager.add(name, anno.fixedRate(), anno.fixedDelay(), anno.concurrent(), (Runnable)runnable);
            } else {
                JobManager.add(name, anno.cron(), anno.zone(), anno.concurrent(), (Runnable)runnable);
            }
        });
        app.onEvent(AppLoadEndEvent.class, e -> JobManager.start());
    }

    public void stop() throws Throwable {
        JobManager.stop();
    }
}

