/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.jackson.xml.JacksonXmlActionExecutor;
import org.noear.solon.serialization.jackson.xml.JacksonXmlRenderFactory;
import org.noear.solon.serialization.jackson.xml.JacksonXmlRenderTypedFactory;
import org.noear.solon.serialization.jackson.xml.impl.NullBeanSerializerModifierImpl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) {
        JsonProps jsonProps = JsonProps.create((AppContext)context);
        JacksonXmlRenderFactory renderFactory = new JacksonXmlRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(JacksonXmlRenderFactory.class, (Object)renderFactory);
        EventBus.publish((Object)renderFactory);
        JacksonXmlRenderTypedFactory renderTypedFactory = new JacksonXmlRenderTypedFactory();
        context.wrapAndPut(JacksonXmlRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(-94, () -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        JacksonXmlActionExecutor actionExecutor = new JacksonXmlActionExecutor();
        context.wrapAndPut(JacksonXmlActionExecutor.class, (Object)actionExecutor);
        EventBus.publish((Object)((Object)actionExecutor));
        Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)actionExecutor);
    }

    private void applyProps(JacksonXmlRenderFactory factory, JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            if (jsonProps.longAsString) {
                factory.addConvertor(Long.class, String::valueOf);
                factory.addConvertor(Long.TYPE, String::valueOf);
            }
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                SerializerFactory serializerFactory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new NullBeanSerializerModifierImpl(jsonProps));
                factory.config().setSerializerFactory(serializerFactory);
            }
            if (jsonProps.enumAsName) {
                factory.config().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            factory.config().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        factory.config().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        factory.config().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        factory.config().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        factory.config().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        factory.config().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        factory.config().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        factory.config().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        factory.config().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

