/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.jackson.xml.JacksonXmlRenderFactoryBase;
import org.noear.solon.serialization.jackson.xml.JacksonXmlStringSerializer;

public class JacksonXmlRenderTypedFactory
extends JacksonXmlRenderFactoryBase {
    private XmlMapper config = new XmlMapper();

    public JacksonXmlRenderTypedFactory() {
        this.config.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.config.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.config.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.config.activateDefaultTypingAsProperty(this.config.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        this.config.registerModule((Module)new JavaTimeModule());
    }

    public Render create() {
        this.registerModule();
        JacksonXmlStringSerializer serializer = new JacksonXmlStringSerializer();
        serializer.setConfig(this.config);
        return new StringSerializerRender(true, (ContextSerializer)serializer);
    }

    @Override
    public XmlMapper config() {
        return this.config;
    }
}

