/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.serialization.ContextSerializer;

public class JacksonXmlStringSerializer
implements ContextSerializer<String> {
    public static final String label = "/xml";
    private XmlMapper config;

    public XmlMapper getConfig() {
        if (this.config == null) {
            this.config = new XmlMapper();
        }
        return this.config;
    }

    public void setConfig(XmlMapper config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String getContentType() {
        return "text/xml";
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label);
    }

    public String name() {
        return "jackson-xml";
    }

    public String serialize(Object obj) throws IOException {
        return this.getConfig().writeValueAsString(obj);
    }

    public Object deserialize(String data, Class<?> clz) throws IOException {
        if (clz == null) {
            return this.getConfig().readTree(data);
        }
        return this.getConfig().readValue(data, clz);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.getContentType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getConfig().readTree(data);
        }
        return null;
    }
}

