/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.StringSerializer;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.jackson.JacksonRenderFactoryBase;
import org.noear.solon.serialization.jackson.JacksonSerializer;

public class JacksonRenderFactory
extends JacksonRenderFactoryBase {
    ObjectMapper config = new ObjectMapper();

    public JacksonRenderFactory() {
        this.config.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.config.registerModule((Module)new JavaTimeModule());
        this.config.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.config.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public Render create() {
        this.registerModule();
        return new StringSerializerRender(false, (StringSerializer)new JacksonSerializer(this.config));
    }

    @Override
    public ObjectMapper config() {
        return this.config;
    }
}

