/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.OValueType;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Context;
import org.noear.snack.core.exts.EnumWrap;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.utils.BeanUtil;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.to.Toer;

public class ObjectToer
implements Toer {
    @Override
    public void handle(Context ctx) throws Exception {
        if (null != ctx.node && null != ctx.type) {
            ctx.object = this.analyse(ctx.config, ctx.node, ctx.type, ctx.type);
        }
    }

    private Class<?> getTypeByNode(Constants cfg, ONode o, Class<?> def) {
        ONode o1;
        String typeStr = null;
        if (o.isArray() && o.count() == 2 && (o1 = o.get(0)).count() == 1) {
            o = o1;
        }
        if (o.isObject()) {
            typeStr = o.get(cfg.type_key).getString();
        }
        if (!StringUtil.isEmpty(typeStr)) {
            Class<?> clz = BeanUtil.loadClass(typeStr);
            if (clz == null) {
                throw new RuntimeException("unsupport type " + typeStr);
            }
            return clz;
        }
        return def;
    }

    private Object analyse(Constants cfg, ONode o, Class<?> clz, Type type) throws Exception {
        if (o == null) {
            return null;
        }
        if (ONode.class.isAssignableFrom(clz)) {
            return o;
        }
        switch (o.nodeType()) {
            case Value: {
                return this.analyseVal(cfg, o.nodeData(), clz);
            }
            case Object: {
                clz = this.getTypeByNode(cfg, o, clz);
                o.remove(cfg.type_key);
                if (Map.class.isAssignableFrom(clz)) {
                    return this.analyseMap(cfg, o, clz, type);
                }
                if (StackTraceElement.class.isAssignableFrom(clz)) {
                    return new StackTraceElement(o.get("declaringClass").getString(), o.get("methodName").getString(), o.get("fileName").getString(), o.get("lineNumber").getInt());
                }
                return this.analyseBean(cfg, o, clz);
            }
            case Array: {
                clz = this.getTypeByNode(cfg, o, clz);
                if (clz.isArray()) {
                    return this.analyseArray(cfg, o.nodeData(), clz);
                }
                return this.analyseCollection(cfg, o, clz, type);
            }
        }
        return null;
    }

    private boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }

    public Object analyseVal(Constants cfg, ONodeData d, Class<?> clz) throws Exception {
        OValue v = d.value;
        if (v.type() == OValueType.Null) {
            return null;
        }
        if (this.is(Byte.class, clz) || clz == Byte.TYPE) {
            return (byte)v.getLong();
        }
        if (this.is(Short.class, clz) || clz == Short.TYPE) {
            return v.getShort();
        }
        if (this.is(Integer.class, clz) || clz == Integer.TYPE) {
            return v.getInt();
        }
        if (this.is(Long.class, clz) || clz == Long.TYPE) {
            return v.getLong();
        }
        if (this.is(Float.class, clz) || clz == Float.TYPE) {
            return Float.valueOf(v.getFloat());
        }
        if (this.is(Double.class, clz) || clz == Double.TYPE) {
            return v.getDouble();
        }
        if (this.is(Boolean.class, clz) || clz == Boolean.TYPE) {
            return v.getBoolean();
        }
        if (this.is(Character.class, clz) || clz == Character.TYPE) {
            return Character.valueOf(v.getChar());
        }
        if (this.is(String.class, clz)) {
            return v.getString();
        }
        if (this.is(Timestamp.class, clz)) {
            return new Timestamp(v.getLong());
        }
        if (this.is(Date.class, clz)) {
            return new Date(v.getLong());
        }
        if (this.is(Time.class, clz)) {
            return new Time(v.getLong());
        }
        if (this.is(java.util.Date.class, clz)) {
            return v.getDate();
        }
        if (this.is(BigDecimal.class, clz)) {
            if (v.type() == OValueType.Bignumber) {
                return v.getRawBignumber();
            }
            return new BigDecimal(v.getString());
        }
        if (this.is(BigInteger.class, clz)) {
            if (v.type() == OValueType.Bignumber) {
                return v.getRawBignumber();
            }
            return new BigInteger(v.getString());
        }
        if (clz.isEnum()) {
            return this.analyseEnum(cfg, d, clz);
        }
        if (this.is(Class.class, clz)) {
            return BeanUtil.loadClass(v.getString());
        }
        if (this.is(Object.class, clz)) {
            return v.getRaw();
        }
        throw new RuntimeException("unsupport type " + clz.getName());
    }

    public Object analyseEnum(Constants cfg, ONodeData d, Class<?> target) {
        EnumWrap ew = TypeUtil.createEnum(target);
        if (d.value.type() == OValueType.String) {
            return ew.get(d.value.getString());
        }
        return ew.get(d.value.getInt());
    }

    public Object analyseArray(Constants cfg, ONodeData d, Class<?> target) throws Exception {
        int len = d.array.size();
        if (this.is(byte[].class, target)) {
            byte[] val = new byte[len];
            for (int i = 0; i < len; ++i) {
                val[i] = (byte)d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(short[].class, target)) {
            short[] val = new short[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getShort();
            }
            return val;
        }
        if (this.is(int[].class, target)) {
            int[] val = new int[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getInt();
            }
            return val;
        }
        if (this.is(long[].class, target)) {
            long[] val = new long[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(float[].class, target)) {
            float[] val = new float[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getFloat();
            }
            return val;
        }
        if (this.is(double[].class, target)) {
            double[] val = new double[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getDouble();
            }
            return val;
        }
        if (this.is(boolean[].class, target)) {
            boolean[] val = new boolean[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getBoolean();
            }
            return val;
        }
        if (this.is(char[].class, target)) {
            char[] val = new char[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getChar();
            }
            return val;
        }
        if (this.is(String[].class, target)) {
            String[] val = new String[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getString();
            }
            return val;
        }
        if (this.is(Object[].class, target)) {
            Class<?> c = target.getComponentType();
            Object[] val = (Object[])Array.newInstance(c, len);
            for (int i = 0; i < len; ++i) {
                val[i] = this.analyse(cfg, d.array.get(i), c, c);
            }
            return val;
        }
        throw new RuntimeException("unsupport type " + target.getName());
    }

    public Object analyseCollection(Constants cfg, ONode o, Class<?> clz, Type type) throws Exception {
        ONode o1;
        Collection list = TypeUtil.createCollection(clz, false);
        if (list == null) {
            return null;
        }
        Type itemType = TypeUtil.getCollectionItemType(type);
        if (o.count() == 2 && (o1 = o.get(0)).count() == 1 && o1.contains(cfg.type_key)) {
            o = o.get(1);
        }
        for (ONode o12 : o.nodeData().array) {
            list.add(this.analyse(cfg, o12, (Class)itemType, itemType));
        }
        return list;
    }

    public Object analyseMap(Constants cfg, ONode o, Class<?> clz, Type type) throws Exception {
        Map<Object, Object> map = TypeUtil.createMap(clz);
        if (type instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)type;
            Type kType = ptt.getActualTypeArguments()[0];
            Type vType = ptt.getActualTypeArguments()[1];
            if (kType instanceof ParameterizedType) {
                kType = ((ParameterizedType)kType).getRawType();
            }
            if (vType instanceof ParameterizedType) {
                vType = ((ParameterizedType)vType).getRawType();
            }
            if (kType == String.class) {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(kv.getKey(), this.analyse(cfg, kv.getValue(), (Class)vType, vType));
                }
            } else {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(TypeUtil.strTo(kv.getKey(), (Class)kType), this.analyse(cfg, kv.getValue(), (Class)vType, vType));
                }
            }
        } else {
            for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                map.put(kv.getKey(), this.analyse(cfg, kv.getValue(), Object.class, (Type)((Object)Object.class)));
            }
        }
        return map;
    }

    public Object analyseBean(Constants cfg, ONode o, Class<?> target) throws Exception {
        if (this.is(SimpleDateFormat.class, target)) {
            return new SimpleDateFormat(o.get("val").getString());
        }
        if (this.is(InetSocketAddress.class, target)) {
            return new InetSocketAddress(o.get("address").getString(), o.get("port").getInt());
        }
        Object rst = null;
        try {
            rst = target.newInstance();
        }
        catch (Exception ex) {
            throw new Exception("create instance error, class " + target.getName());
        }
        for (FieldWrap f : BeanUtil.getAllFields(target)) {
            String key = f.name();
            if (!o.contains(key)) continue;
            f.set(rst, this.analyse(cfg, o.get(key), f.clz, f.type));
        }
        return rst;
    }
}

