/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.snack.ONodeData;
import org.noear.snack.ONodeType;
import org.noear.snack.OValue;
import org.noear.snack.core.Constants;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.exts.Act1;
import org.noear.snack.core.exts.Act2;
import org.noear.snack.core.utils.NodeUtil;

public class ONode {
    protected Constants _c = Constants.def;
    protected ONodeData _d = new ONodeData(this);

    public static String version() {
        return "3.0.14";
    }

    public ONode() {
    }

    public ONode(Constants cfg) {
        this._c = cfg;
    }

    public ONode asObject() {
        this._d.tryInitObject(this._c);
        return this;
    }

    public ONode asArray() {
        this._d.tryInitArray();
        return this;
    }

    public ONode asValue() {
        this._d.tryInitValue();
        return this;
    }

    public ONode asNull() {
        this._d.tryInitNull();
        return this;
    }

    public ONodeData nodeData() {
        return this._d;
    }

    public ONodeType nodeType() {
        return this._d.nodeType;
    }

    public ONode cfg(Constants constants) {
        this._c = constants != null ? constants : Constants.def;
        return this;
    }

    public ONode build(Act1<ONode> fun) {
        fun.run(this);
        return this;
    }

    public OValue val() {
        return this.asValue()._d.value;
    }

    public ONode val(Object val) {
        if (val == null) {
            this._d.tryInitNull();
        } else if (val instanceof ONode) {
            this._d.tryInitNull();
            this._d = ((ONode)val)._d;
        } else {
            this._d.tryInitValue();
            this._d.value.set(val);
        }
        return this;
    }

    public String getString() {
        if (this.isValue()) {
            return this._d.value.getString();
        }
        if (this.isArray()) {
            return this.toJson();
        }
        if (this.isObject()) {
            return this.toJson();
        }
        return this._c.null_string;
    }

    public short getShort() {
        if (this.isValue()) {
            return this._d.value.getShort();
        }
        return 0;
    }

    public int getInt() {
        if (this.isValue()) {
            return this._d.value.getInt();
        }
        return 0;
    }

    public boolean getBoolean() {
        if (this.isValue()) {
            return this._d.value.getBoolean();
        }
        return false;
    }

    public long getLong() {
        if (this.isValue()) {
            return this._d.value.getLong();
        }
        return 0L;
    }

    public Date getDate() {
        if (this.isValue()) {
            return this._d.value.getDate();
        }
        return null;
    }

    public float getFloat() {
        if (this.isValue()) {
            return this._d.value.getFloat();
        }
        return 0.0f;
    }

    public double getDouble() {
        if (this.isValue()) {
            return this._d.value.getDouble();
        }
        return 0.0;
    }

    public double getDouble(int scale) {
        double temp = this.getDouble();
        if (temp == 0.0) {
            return 0.0;
        }
        return new BigDecimal(temp).setScale(scale, 4).doubleValue();
    }

    public char getChar() {
        if (this.isValue()) {
            return this._d.value.getChar();
        }
        return '\u0000';
    }

    public void clear() {
        if (this.isObject()) {
            this._d.object.clear();
        } else if (this.isArray()) {
            this._d.array.clear();
        }
    }

    public int count() {
        if (this.isObject()) {
            return this._d.object.size();
        }
        if (this.isArray()) {
            return this._d.array.size();
        }
        return 0;
    }

    public Map<String, ONode> obj() {
        return this.asObject()._d.object;
    }

    public boolean contains(String key) {
        if (this.isObject()) {
            return this._d.object.containsKey(key);
        }
        return false;
    }

    public ONode get(String key) {
        this._d.tryInitObject(this._c);
        ONode tmp = this._d.object.get(key);
        if (tmp == null) {
            tmp = new ONode(this._c);
            this._d.object.put(key, tmp);
        }
        return tmp;
    }

    public ONode getOrNull(String key) {
        this._d.tryInitObject(this._c);
        return this._d.object.get(key);
    }

    public ONode getNew(String key) {
        ONode tmp = new ONode(this._c);
        this._d.object.put(key, tmp);
        return tmp;
    }

    public ONode set(String key, Object val) {
        this._d.tryInitObject(this._c);
        if (val instanceof ONode) {
            this._d.object.put(key, ((ONode)val).cfg(this._c));
        } else {
            this._d.object.put(key, new ONode(this._c).val(val));
        }
        return this;
    }

    public ONode setNode(String key, ONode val) {
        this._d.object.put(key, val);
        return this;
    }

    public ONode setAll(ONode obj) {
        this._d.tryInitObject(this._c);
        if (obj != null && obj.isObject()) {
            this._d.object.putAll(obj._d.object);
        }
        return this;
    }

    public <T> ONode setAll(Map<String, T> map) {
        this._d.tryInitObject(this._c);
        if (map != null) {
            map.forEach((? super K k, ? super V v) -> this.set((String)k, v));
        }
        return this;
    }

    public <T> ONode setAll(Map<String, T> map, Act2<ONode, T> handler) {
        this._d.tryInitObject(this._c);
        if (map != null) {
            map.forEach((? super K k, ? super V v) -> handler.run(this.get((String)k), v));
        }
        return this;
    }

    public void remove(String key) {
        this._d.tryInitObject(this._c);
        this._d.object.remove(key);
    }

    public List<ONode> ary() {
        return this.asArray()._d.array;
    }

    public ONode get(int index) {
        this._d.tryInitArray();
        if (index >= 0 && this._d.array.size() > index) {
            return this._d.array.get(index);
        }
        return new ONode();
    }

    public ONode getOrNull(int index) {
        this._d.tryInitArray();
        if (index >= 0 && this._d.array.size() > index) {
            return this._d.array.get(index);
        }
        return null;
    }

    public void removeAt(int index) {
        this._d.tryInitArray();
        this._d.array.remove(index);
    }

    public ONode addNew() {
        this._d.tryInitArray();
        ONode n = new ONode().cfg(this._c);
        this._d.array.add(n);
        return n;
    }

    public ONode add(Object val) {
        this._d.tryInitArray();
        if (val instanceof ONode) {
            this._d.array.add((ONode)val);
        } else {
            this._d.array.add(new ONode(this._c).val(val));
        }
        return this;
    }

    public void addNode(ONode val) {
        this._d.array.add(val);
    }

    public ONode addAll(ONode ary) {
        this._d.tryInitArray();
        if (ary != null && ary.isArray()) {
            this._d.array.addAll(ary._d.array);
        }
        return this;
    }

    public <T> ONode addAll(Collection<T> ary) {
        this._d.tryInitArray();
        if (ary != null) {
            ary.forEach((? super T m) -> this.add(m));
        }
        return this;
    }

    public <T> ONode addAll(Collection<T> ary, Act2<ONode, T> handler) {
        this._d.tryInitArray();
        if (ary != null) {
            ary.forEach((? super T m) -> handler.run(this.addNew(), m));
        }
        return this;
    }

    public boolean isNull() {
        return this._d.nodeType == ONodeType.Null || this.isValue() && this._d.value.isNull();
    }

    public boolean isValue() {
        return this._d.nodeType == ONodeType.Value;
    }

    public boolean isObject() {
        return this._d.nodeType == ONodeType.Object;
    }

    public boolean isArray() {
        return this._d.nodeType == ONodeType.Array;
    }

    public void forEach(BiConsumer<String, ONode> consumer) {
        if (this.isObject()) {
            this._d.object.forEach(consumer);
        }
    }

    public void forEach(Consumer<ONode> consumer) {
        if (this.isArray()) {
            this._d.array.forEach(consumer);
        }
    }

    public String attrGet(String key) {
        return this._d.attrGet(key);
    }

    public void attrSet(String key, String val) {
        this._d.attrSet(key, val);
    }

    public void attrForeach(BiConsumer<String, String> consumer) {
        if (this._d.attrs != null) {
            this._d.attrs.forEach(consumer);
        }
    }

    public String toString() {
        return NodeUtil.toStr(this._c, this, this._c.stringToer);
    }

    public String toJson() {
        return NodeUtil.toStr(this._c, this, DEFAULTS.DEF_JSON_TOER);
    }

    public Object toData() {
        return NodeUtil.toObj(this._c, this, ONode.class, DEFAULTS.DEF_DATA_TOER);
    }

    public <T> T toBean(Class<T> clz) {
        return (T)NodeUtil.toObj(this._c, this, clz, this._c.objectToer);
    }

    public ONode fill(Object source) {
        ONode tmp = ONode.load(source);
        this.val(tmp);
        return this;
    }

    public ONode fillObj(Object source) throws Exception {
        ONode tmp = ONode.loadObj(source);
        this.val(tmp);
        return this;
    }

    public ONode fillStr(String source) throws Exception {
        ONode tmp = ONode.loadStr(source);
        this.val(tmp);
        return this;
    }

    public static ONode load(Object source) {
        try {
            if (source instanceof String) {
                return NodeUtil.fromStr((String)source);
            }
            return NodeUtil.fromObj(source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ONode();
        }
    }

    public static ONode loadStr(String source) throws Exception {
        return NodeUtil.fromStr(source);
    }

    public static ONode loadObj(Object source) throws Exception {
        return NodeUtil.fromObj(source);
    }

    public static String serialize(Object source) throws Exception {
        return NodeUtil.fromObj(Constants.serialize, source).toJson();
    }

    public static String serialize(Object source, Constants constants) throws Exception {
        return NodeUtil.fromObj(constants, source).toJson();
    }

    public static <T> T deserialize(String source, Class<?> clz) throws Exception {
        return (T)NodeUtil.fromStr(Constants.serialize, source).toBean(clz);
    }

    public static <T> T deserialize(String source, Class<?> clz, Constants constants) throws Exception {
        return (T)NodeUtil.fromStr(constants, source).toBean(clz);
    }
}

