/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.Act1;
import org.noear.snack.from.Fromer;
import org.noear.snack.to.Toer;

public class Constants {
    public static final Constants def = Constants.of(Feature.WriteDateUseTicks).build(c -> {
        c.null_string = "";
    });
    public static final Constants serialize = Constants.of(Feature.OrderedField, Feature.BrowserCompatible, Feature.WriteClassName).build(c -> {
        c.null_string = null;
    });
    private SimpleDateFormat _date_format;
    public String null_string = "";
    public String date_format = "yyyy-MM-dd HH:mm:ss";
    public String type_key = "@type";
    public TimeZone time_zone = DEFAULTS.DEF_TIME_ZONE;
    public Locale locale = DEFAULTS.DEF_LOCALE;
    public int features = DEFAULTS.DEF_FEATURES;
    public Fromer stringFromer = DEFAULTS.DEF_JSON_FROMER;
    public Toer stringToer = DEFAULTS.DEF_JSON_TOER;
    public Fromer objectFromer = DEFAULTS.DEF_OBJECT_FROMER;
    public Toer objectToer = DEFAULTS.DEF_OBJECT_TOER;

    public static Constants of(Feature ... features) {
        Constants l = new Constants();
        for (Feature f : features) {
            l.features = Feature.config(l.features, f, true);
        }
        return l;
    }

    public Constants build(Act1<Constants> builder) {
        builder.run(this);
        return this;
    }

    public Constants() {
        this.initialize();
    }

    protected void initialize() {
        this._date_format = new SimpleDateFormat(this.date_format, this.locale);
        this.features = Feature.config(this.features, Feature.QuoteFieldNames, true);
    }

    public final String dateToString(Date date) {
        return this._date_format.format(date);
    }

    public final boolean hasFeature(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }
}

