/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.util.Collection;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ActionExecuteHandlerDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class SnackActionExecutor
extends ActionExecuteHandlerDefault {
    static final SnackActionExecutor global = new SnackActionExecutor();
    private static final String label = "/json";
    private final Options config = Options.def().add(new Feature[]{Feature.DisableClassNameRead});

    public Options config() {
        return this.config;
    }

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        String json = ctx.bodyNew();
        if (Utils.isNotEmpty((String)json)) {
            return ONode.loadStr((String)json, (Options)this.config);
        }
        return null;
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (!p.isRequiredBody() && ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.isRequiredBody() && tmp.contains(p.getName())) {
                if (p.isGenericType()) {
                    return tmp.get(p.getName()).toObject(p.getGenericType());
                }
                return tmp.get(p.getName()).toObject(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toObject(p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toObject(p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        return tmp.val().getRaw();
    }
}

