/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.snack.ONode;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.serialization.ContextSerializer;

public class SnackStringSerializer
implements ContextSerializer<String> {
    private static final String label = "/json";
    private Options config;

    public Options getConfig() {
        if (this.config == null) {
            this.config = Options.def();
        }
        return this.config;
    }

    public void setConfig(Options config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String getContentType() {
        return "application/json";
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label);
    }

    public String name() {
        return "snack3-json";
    }

    public String serialize(Object obj) throws IOException {
        return ONode.loadObj((Object)obj, (Options)this.getConfig()).toJson();
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return ONode.loadStr((String)data, (Options)this.getConfig());
        }
        return ONode.loadStr((String)data, (Options)this.getConfig()).toObject(toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.getContentType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return ONode.loadStr((String)data, (Options)this.getConfig());
        }
        return null;
    }
}

