/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.prop;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.prop.JsonProps;

public class JsonPropsUtil {
    public static boolean apply(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return false;
        }
        if (Utils.isNotEmpty((String)jsonProps.dateAsFormat)) {
            factory.addConvertor(Date.class, e -> {
                SimpleDateFormat df = new SimpleDateFormat(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.setTimeZone(TimeZone.getTimeZone(jsonProps.dateAsTimeZone));
                }
                return df.format((Date)e);
            });
        }
        if (jsonProps.longAsString) {
            factory.addConvertor(Long.class, e -> String.valueOf(e));
        }
        if (jsonProps.intAsString) {
            factory.addConvertor(Integer.class, e -> String.valueOf(e));
        }
        if (jsonProps.boolAsInt) {
            factory.addConvertor(Boolean.class, e -> e != false ? 1 : 0);
        }
        return true;
    }
}

