/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Base64;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.sessionstate.jedis.ObjectInputStreamEx;

public class JavabinSerializer
implements Serializer<String> {
    public static final JavabinSerializer instance = new JavabinSerializer();

    public String name() {
        return "java-bin";
    }

    public String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] tmp = this.serializeDo(obj);
        return Base64.getEncoder().encodeToString(tmp);
    }

    public Object deserialize(String dta, Class<?> clz) {
        if (dta == null) {
            return null;
        }
        ClassLoader loader = ClassUtil.resolveClassLoader(clz);
        byte[] bytes = Base64.getDecoder().decode(dta);
        return this.deserializeDo(loader, bytes);
    }

    protected byte[] serializeDo(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + object.getClass(), e);
        }
        return baos.toByteArray();
    }

    protected Object deserializeDo(ClassLoader loader, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStreamEx ois = new ObjectInputStreamEx(loader, new ByteArrayInputStream(bytes));
            return ois.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to deserialize object type", e);
        }
    }
}

