/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.local;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.noear.solon.core.util.RunUtil;

class ScheduledStore {
    private int _defaultSeconds;
    private Map<String, Entity> _data = new HashMap<String, Entity>();

    public ScheduledStore(int seconds) {
        this._defaultSeconds = seconds;
    }

    public Collection<String> keys() {
        return this._data.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String block, String key, Object obj) {
        Map<String, Entity> map = this._data;
        synchronized (map) {
            Entity ent = this._data.get(block);
            if (ent == null) {
                ent = new Entity();
                this._data.put(block, ent);
            } else {
                ent.futureDel();
            }
            ent.map.put(key, obj);
            ent.future = RunUtil.delay(() -> this._data.remove(block), (long)(this._defaultSeconds * 1000));
        }
    }

    public void delay(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            ent.futureDel();
            ent.future = RunUtil.delay(() -> this._data.remove(block), (long)(this._defaultSeconds * 1000));
        }
    }

    public Object get(String block, String key) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            return ent.map.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String block, String key) {
        Map<String, Entity> map = this._data;
        synchronized (map) {
            Entity ent = this._data.get(block);
            if (ent != null) {
                ent.map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String block) {
        Map<String, Entity> map = this._data;
        synchronized (map) {
            Entity ent = this._data.get(block);
            if (ent != null) {
                ent.futureDel();
                this._data.remove(block);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Entity> map = this._data;
        synchronized (map) {
            for (Entity ent : this._data.values()) {
                ent.futureDel();
            }
            this._data.clear();
        }
    }

    private static class Entity {
        public Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        public Future future;

        private Entity() {
        }

        protected void futureDel() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }
}

