/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.redisson;

import java.util.Properties;
import org.noear.solon.Utils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedissonBuilder {
    public static RedissonClient build(Properties prop) {
        String server_str = prop.getProperty("server");
        String db_str = prop.getProperty("db");
        String user_str = prop.getProperty("user");
        String password_str = prop.getProperty("password");
        int db = 0;
        if (Utils.isNotEmpty((String)db_str)) {
            db = Integer.parseInt(db_str);
        }
        Config config = new Config();
        if (server_str.contains(",")) {
            ClusterServersConfig serverConfig = config.useClusterServers();
            Utils.injectProperties((Object)serverConfig, (Properties)prop);
            String[] address = RedissonBuilder.resolveServers(server_str.split(","));
            ((ClusterServersConfig)serverConfig.addNodeAddress(address).setUsername(user_str)).setPassword(password_str);
        } else {
            SingleServerConfig serverConfig = config.useSingleServer();
            Utils.injectProperties((Object)serverConfig, (Properties)prop);
            String[] address = RedissonBuilder.resolveServers(server_str);
            ((SingleServerConfig)((SingleServerConfig)serverConfig.setAddress(address[0]).setUsername(user_str)).setPassword(password_str)).setDatabase(db);
        }
        return Redisson.create((Config)config);
    }

    private static String[] resolveServers(String ... servers) {
        String[] uris = new String[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            String sev = servers[i];
            uris[i] = sev.contains("://") ? sev : "redis://" + sev;
        }
        return uris;
    }
}

