/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.jdksocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import org.noear.solon.Utils;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ConnectorBase;
import org.noear.solon.socketd.ListenerProxy;
import org.noear.solon.socketd.SocketProps;
import org.noear.solon.socketd.client.jdksocket.BioReceiver;

public class BioConnector
extends ConnectorBase<Socket> {
    public BioConnector(URI uri, boolean autoReconnect) {
        super(uri, autoReconnect);
    }

    public Class<Socket> driveType() {
        return Socket.class;
    }

    public Socket open(Session session) {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(this.uri().getHost(), this.uri().getPort());
            Socket socket = new Socket();
            if (SocketProps.socketTimeout() > 0) {
                socket.setSoTimeout(SocketProps.socketTimeout());
            }
            if (SocketProps.connectTimeout() > 0) {
                socket.connect(socketAddress, SocketProps.connectTimeout());
            } else {
                socket.connect(socketAddress);
            }
            this.startReceive(session, socket);
            return socket;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void startReceive(Session session, Socket socket) {
        Utils.pools.submit(() -> {
            while (true) {
                if (socket.isClosed()) break;
                try {
                    Message message = BioReceiver.receive(socket);
                    if (message == null) continue;
                    Utils.pools.execute(() -> {
                        try {
                            ListenerProxy.getGlobal().onMessage(session, message);
                        }
                        catch (Throwable ex) {
                            ListenerProxy.getGlobal().onError(session, ex);
                        }
                    });
                }
                catch (Exception ex) {
                    ListenerProxy.getGlobal().onError(session, (Throwable)ex);
                }
            }
            ListenerProxy.getGlobal().onClose(session);
        });
    }
}

