/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.jdksocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.Connector;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;

public class BioSocketSession
extends SessionBase {
    public static Map<Socket, Session> sessions = new HashMap<Socket, Session>();
    Socket real;
    Connector<Socket> connector;
    boolean autoReconnect;
    private String _sessionId = Utils.guid();
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(Socket real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            Socket socket = real;
            synchronized (socket) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new BioSocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(Socket real) {
        sessions.remove(real);
    }

    public BioSocketSession(Socket real) {
        this.real = real;
    }

    public BioSocketSession(Connector<Socket> connector) {
        this.connector = connector;
        this.autoReconnect = connector.autoReconnect();
    }

    private boolean prepareNew() throws IOException {
        if (this.real == null) {
            this.real = (Socket)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        return false;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public URI uri() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.uri();
    }

    public String path() {
        if (this.connector == null) {
            return "";
        }
        return this.connector.uri().getPath();
    }

    public void send(String message) {
        this.send(Message.wrap((String)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        try {
            super.send(message);
            BioSocketSession bioSocketSession = this;
            synchronized (bioSocketSession) {
                if (this.prepareNew()) {
                    this.send0(this.handshakeMessage);
                }
                this.send0(message);
            }
        }
        catch (SocketException ex) {
            if (this.autoReconnect) {
                this.real = null;
            }
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void send0(Message message) throws IOException {
        if (message == null) {
            return;
        }
        ByteBuffer buffer = ProtocolManager.encode((Message)message);
        if (buffer != null) {
            this.real.getOutputStream().write(buffer.array());
            this.real.getOutputStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Socket socket = this.real;
        synchronized (socket) {
            this.real.shutdownInput();
            this.real.shutdownOutput();
            this.real.close();
            sessions.remove(this.real);
        }
    }

    public boolean isValid() {
        return this.real.isConnected();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.real.getLocalSocketAddress();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return Collections.unmodifiableCollection(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BioSocketSession that = (BioSocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

