/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.smartsocket.decoder;

import java.nio.ByteBuffer;

public class FixedLengthFrameDecoder {
    private final int length;
    private final ByteBuffer buffer;

    public FixedLengthFrameDecoder(int frameLength) {
        this.length = frameLength;
        this.buffer = ByteBuffer.allocate(frameLength);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    public boolean read(ByteBuffer byteBuffer) {
        int len0 = this.length - this.buffer.position();
        if (len0 > byteBuffer.remaining()) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, byteBuffer.remaining());
            this.buffer.put(bytes);
            return false;
        }
        byte[] bytes = new byte[len0];
        byteBuffer.get(bytes, 0, len0);
        this.buffer.put(bytes);
        return true;
    }
}

