/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd.client.smartsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.Connector;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;
import org.smartboot.socket.transport.AioSession;

public class AioSocketSession
extends SessionBase {
    public static Map<AioSession, Session> sessions = new HashMap<AioSession, Session>();
    AioSession real;
    Connector<AioSession> connector;
    boolean autoReconnect;
    private String _sessionId = Utils.guid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(AioSession real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            AioSession aioSession = real;
            synchronized (aioSession) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new AioSocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(AioSession real) {
        sessions.remove(real);
    }

    public AioSocketSession(AioSession real) {
        this.real = real;
    }

    public AioSocketSession(Connector<AioSession> connector) {
        this.connector = connector;
        this.autoReconnect = connector.autoReconnect();
    }

    private boolean prepareNew() throws IOException {
        if (this.real == null) {
            this.real = (AioSession)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        if (this.autoReconnect && this.real.isInvalid()) {
            this.real = (AioSession)this.connector.open((Session)this);
            this.onOpen();
            return true;
        }
        return false;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public URI uri() {
        if (this.connector == null) {
            return null;
        }
        return this.connector.uri();
    }

    public String path() {
        if (this.connector == null) {
            return "";
        }
        return this.connector.uri().getPath();
    }

    public void send(String message) {
        this.send(Message.wrap((String)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        try {
            super.send(message);
            AioSocketSession aioSocketSession = this;
            synchronized (aioSocketSession) {
                if (this.prepareNew()) {
                    this.send0(this.handshakeMessage);
                }
                this.send0(message);
            }
        }
        catch (ClosedChannelException ex) {
            if (this.autoReconnect) {
                this.real = null;
            }
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void send0(Message message) throws IOException {
        if (message == null) {
            return;
        }
        ByteBuffer buffer = ProtocolManager.encode((Message)message);
        if (buffer != null) {
            this.real.writeBuffer().writeAndFlush(buffer.array());
        }
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return !this.real.isInvalid();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        try {
            return this.real.getRemoteAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return this.real.getLocalAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAttachment(Object obj) {
        this.real.setAttachment(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttachment();
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AioSocketSession that = (AioSocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

