/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.Response;
import org.noear.solon.Solon;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.test.HttpCallback;
import org.noear.solon.test.http.impl.HttpUtilsImpl;

public interface HttpUtils {
    public static HttpUtils http(String service, String path) {
        String url = LoadBalance.get((String)service).getServer() + path;
        return HttpUtils.http(url);
    }

    public static HttpUtils http(String group, String service, String path) {
        String url = LoadBalance.get((String)group, (String)service).getServer() + path;
        return HttpUtils.http(url);
    }

    public static HttpUtils http(String url) {
        return new HttpUtilsImpl(url);
    }

    public HttpUtils enablePrintln(boolean var1);

    public HttpUtils timeout(int var1);

    public HttpUtils timeout(int var1, int var2, int var3);

    public HttpUtils multipart(boolean var1);

    public HttpUtils userAgent(String var1);

    public HttpUtils charset(String var1);

    public HttpUtils headers(Map<String, String> var1);

    public HttpUtils header(String var1, String var2);

    public HttpUtils headerAdd(String var1, String var2);

    public HttpUtils data(Map var1);

    public HttpUtils data(String var1, String var2);

    public HttpUtils data(String var1, String var2, InputStream var3, String var4);

    public HttpUtils bodyTxt(String var1);

    public HttpUtils bodyTxt(String var1, String var2);

    public HttpUtils bodyJson(String var1);

    public HttpUtils bodyRaw(byte[] var1);

    public HttpUtils bodyRaw(byte[] var1, String var2);

    public HttpUtils bodyRaw(InputStream var1);

    public HttpUtils bodyRaw(InputStream var1, String var2);

    public HttpUtils cookies(Map var1);

    public Response exec(String var1) throws IOException;

    public String execAsBody(String var1) throws IOException;

    public int execAsCode(String var1) throws IOException;

    public String get() throws IOException;

    public String post() throws IOException;

    public void postAsync() throws IOException;

    public void postAsync(HttpCallback<Boolean, Response, Exception> var1) throws IOException;

    public void headAsync(HttpCallback<Boolean, Response, Exception> var1) throws IOException;

    public String put() throws IOException;

    public String patch() throws IOException;

    public String delete() throws IOException;

    public String options() throws IOException;

    public int head() throws IOException;

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, Solon.encoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String toQueryString(Map<?, ?> map) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", HttpUtils.urlEncode(entry.getKey().toString()), HttpUtils.urlEncode(entry.getValue().toString())));
        }
        return sb.toString();
    }
}

