/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test.data;

import java.util.concurrent.atomic.AtomicReference;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.annotation.TranAnno;
import org.noear.solon.data.tran.TranUtils;
import org.noear.solon.test.annotation.TestRollback;
import org.noear.solon.test.data.TestRollbackException;

public class TestRollbackInterceptor
implements Interceptor {
    public Object doIntercept(Invocation inv) throws Throwable {
        AtomicReference val0 = new AtomicReference();
        TestRollback anno0 = (TestRollback)inv.method().getAnnotation(TestRollback.class);
        TranAnno anno1 = new TranAnno();
        if (anno0 != null) {
            anno1.policy(anno0.policy());
            anno1.readOnly(anno0.readOnly());
            anno1.isolation(anno0.isolation());
            anno1.message(anno0.message());
        }
        TestRollbackInterceptor.rollbackDo((Tran)anno1, () -> val0.set(inv.invoke()));
        return val0.get();
    }

    public static void rollbackDo(RunnableEx runnable) throws Throwable {
        TestRollbackInterceptor.rollbackDo(null, runnable);
    }

    public static void rollbackDo(Tran tran, RunnableEx runnable) throws Throwable {
        if (tran == null) {
            tran = new TranAnno();
        }
        try {
            TranUtils.execute((Tran)tran, () -> {
                runnable.run();
                throw new TestRollbackException();
            });
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            if (e instanceof TestRollbackException) {
                System.out.println("@TestRollback: the transaction has been rolled back!");
            }
            throw e;
        }
    }
}

