/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.beetl;

import java.io.File;
import java.net.URI;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.view.beetl.XPluginImp;

public class BeetlRender
implements XRender {
    private static BeetlRender _global;
    Configuration cfg = null;
    GroupTemplate gt = null;
    private String _baseUri = "/WEB-INF/view/";

    public static BeetlRender global() {
        if (_global == null) {
            _global = new BeetlRender();
        }
        return _global;
    }

    public BeetlRender() {
        try {
            this.cfg = Configuration.defaultConfiguration();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String baseUri = XApp.global().prop().get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (XApp.cfg().isDebugMode()) {
            this.forDebug();
        } else {
            this.forRelease();
        }
        XApp.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                FileResourceLoader loader = new FileResourceLoader(dir.getAbsolutePath(), "utf-8");
                this.gt = new GroupTemplate((ResourceLoader)loader, this.cfg);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        try {
            ClasspathResourceLoader loader = new ClasspathResourceLoader(this.getClass().getClassLoader(), this._baseUri);
            this.gt = new GroupTemplate((ResourceLoader)loader, this.cfg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void registerTag(String name, Class<?> tag) {
        try {
            this.gt.registerTag(name, tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.gt.getSharedVars().put(name, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Object obj, XContext ctx) throws Exception {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx);
        } else {
            ctx.output(obj.toString());
        }
    }

    public void render_mav(ModelAndView mv, XContext ctx) throws Exception {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "BeetlRender");
        }
        Template template = this.gt.getTemplate(mv.view());
        template.binding(mv.model());
        template.renderTo(ctx.outputStream());
    }
}

