/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.beetl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.ext.SupplierEx;
import org.noear.solon.view.beetl.XPluginImp;

public class BeetlRender
implements Render {
    private static BeetlRender _global;
    Configuration cfg = null;
    GroupTemplate gt = null;
    GroupTemplate gt_debug = null;
    private String _baseUri = "/WEB-INF/view/";

    public static BeetlRender global() {
        if (_global == null) {
            _global = new BeetlRender();
        }
        return _global;
    }

    public BeetlRender() {
        try {
            this.cfg = Configuration.defaultConfiguration();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String baseUri = Solon.cfg().get("slon.mvc.view.prefix");
        if (!Utils.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (Solon.cfg().isDebugMode()) {
            this.forDebug();
            this.forRelease();
        } else {
            this.forRelease();
        }
        Solon.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        if (this.gt_debug != null) {
            return;
        }
        String dirroot = Utils.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                FileResourceLoader loader = new FileResourceLoader(dir.getAbsolutePath(), "utf-8");
                this.gt_debug = new GroupTemplate((ResourceLoader)loader, this.cfg);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    private void forRelease() {
        if (this.gt != null) {
            return;
        }
        try {
            ClasspathResourceLoader loader = new ClasspathResourceLoader((ClassLoader)JarClassLoader.global(), this._baseUri);
            this.gt = new GroupTemplate((ResourceLoader)loader, this.cfg);
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void registerTag(String name, Class<?> tag) {
        try {
            this.gt.registerTag(name, tag);
            if (this.gt_debug != null) {
                this.gt_debug.registerTag(name, tag);
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.gt.getSharedVars().put(name, value);
            if (this.gt_debug != null) {
                this.gt_debug.getSharedVars().put(name, value);
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    private void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "BeetlRender");
        }
        Template template = null;
        if (this.gt_debug != null && this.gt_debug.hasTemplate((Object)mv.view())) {
            template = this.gt_debug.getTemplate((Object)mv.view());
        }
        if (template == null) {
            template = this.gt.getTemplate((Object)mv.view());
        }
        template.binding(mv.model());
        template.renderTo((OutputStream)outputStream.get());
    }
}

