/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.enjoy;

import com.jfinal.template.source.ISource;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

class ClassPathSource2
implements ISource {
    protected String finalFileName;
    protected String fileName;
    protected String encoding;
    protected boolean isInJar;
    protected long lastModified;
    protected ClassLoader classLoader;
    protected URL url;

    public ClassPathSource2(ClassLoader classLoader, String fileName) {
        this(classLoader, null, fileName, "UTF-8");
    }

    public ClassPathSource2(ClassLoader classLoader, String baseTemplatePath, String fileName) {
        this(classLoader, baseTemplatePath, fileName, "UTF-8");
    }

    public ClassPathSource2(ClassLoader classLoader, String baseTemplatePath, String fileName, String encoding) {
        this.finalFileName = this.buildFinalFileName(baseTemplatePath, fileName);
        this.fileName = fileName;
        this.encoding = encoding;
        this.classLoader = classLoader;
        this.url = this.classLoader.getResource(this.finalFileName);
        if (this.url == null) {
            throw new IllegalArgumentException("File not found in CLASSPATH or JAR : \"" + this.finalFileName + "\"");
        }
        this.processIsInJarAndlastModified();
    }

    protected void processIsInJarAndlastModified() {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            this.isInJar = false;
            this.lastModified = new File(this.url.getFile()).lastModified();
        } else {
            this.isInJar = true;
            this.lastModified = -1L;
        }
    }

    protected String buildFinalFileName(String baseTemplatePath, String fileName) {
        char firstChar;
        String finalFileName = baseTemplatePath != null ? ((firstChar = fileName.charAt(0)) != '/' && firstChar != '\\' ? baseTemplatePath + "/" + fileName : baseTemplatePath + fileName) : fileName;
        if (finalFileName.charAt(0) == '/') {
            finalFileName = finalFileName.substring(1);
        }
        return finalFileName;
    }

    public String getCacheKey() {
        return this.fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected long getLastModified() {
        return new File(this.url.getFile()).lastModified();
    }

    public boolean isModified() {
        return this.isInJar ? false : this.lastModified != this.getLastModified();
    }

    public StringBuilder getContent() {
        InputStream inputStream;
        if (!this.isInJar) {
            this.lastModified = this.getLastModified();
        }
        if ((inputStream = this.classLoader.getResourceAsStream(this.finalFileName)) == null) {
            throw new RuntimeException("File not found : \"" + this.finalFileName + "\"");
        }
        return ClassPathSource2.loadFile(inputStream, this.encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuilder loadFile(InputStream inputStream, String encoding) {
        try (InputStreamReader isr = new InputStreamReader(inputStream, encoding);){
            StringBuilder var19;
            int num;
            StringBuilder ret = new StringBuilder();
            char[] buf = new char[1024];
            while ((num = isr.read(buf, 0, buf.length)) != -1) {
                ret.append(buf, 0, num);
            }
            StringBuilder stringBuilder = var19 = ret;
            return stringBuilder;
        }
        catch (Exception var18) {
            throw new RuntimeException(var18);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("In Jar File: ").append(this.isInJar).append("\n");
        sb.append("File name: ").append(this.fileName).append("\n");
        sb.append("Final file name: ").append(this.finalFileName).append("\n");
        sb.append("Last modified: ").append(this.lastModified).append("\n");
        return sb.toString();
    }
}

