/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.enjoy;

import com.jfinal.template.Directive;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;
import org.noear.solon.view.enjoy.ClassPathSourceFactory2;

public class EnjoyRender
implements Render {
    private static EnjoyRender _global;
    Engine provider = null;
    Engine provider_debug = null;
    private ClassLoader classLoader;

    public static EnjoyRender global() {
        if (_global == null) {
            _global = new EnjoyRender();
        }
        return _global;
    }

    public EnjoyRender() {
        this((ClassLoader)JarClassLoader.global());
    }

    public EnjoyRender(ClassLoader classLoader) {
        this.classLoader = classLoader;
        Engine.setChineseExpression((boolean)true);
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    public Engine getProvider() {
        return this.provider;
    }

    public Engine getProviderDebug() {
        return this.provider_debug;
    }

    private void forDebug() {
        String dir_str;
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (this.provider_debug != null) {
            return;
        }
        URL rooturi = ResourceUtil.getResource((String)"/");
        if (rooturi == null) {
            return;
        }
        this.provider_debug = Engine.create((String)"debug");
        this.provider_debug.setDevMode(true);
        String rootdir = rooturi.toString().replace("target/classes/", "");
        File dir = null;
        if (rootdir.startsWith("file:") && !(dir = new File(URI.create(dir_str = rootdir + "src/main/resources" + ViewConfig.getViewPrefix()))).exists()) {
            dir_str = rootdir + "src/main/webapp" + ViewConfig.getViewPrefix();
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.provider_debug.setBaseTemplatePath(dir.getPath());
                this.provider_debug.setSourceFactory((ISourceFactory)new FileSourceFactory());
            }
            EventBus.push((Object)this.provider_debug);
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = Engine.use();
        this.provider.setDevMode(Solon.cfg().isDebugMode());
        try {
            this.provider.setBaseTemplatePath(ViewConfig.getViewPrefix());
            this.provider.setSourceFactory((ISourceFactory)new ClassPathSourceFactory2(this.classLoader));
            EventBus.push((Object)this.provider);
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void putDirective(String name, Class<? extends Directive> clz) {
        try {
            this.provider.addDirective(name, clz);
            if (this.provider_debug != null) {
                this.provider_debug.addDirective(name, clz);
            }
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.addSharedObject(name, value);
            if (this.provider_debug != null) {
                this.provider_debug.addSharedObject(name, value);
            }
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void putFunction(String path) {
        try {
            this.provider.addSharedFunction(path);
            if (this.provider_debug != null) {
                this.provider_debug.addSharedFunction(path);
            }
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "EnjoyRender");
        }
        Template template = null;
        if (this.provider_debug != null) {
            try {
                template = this.provider_debug.getTemplate(mv.view());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(mv.view());
        }
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        template.render(mv.model(), (Writer)writer);
        writer.flush();
    }
}

