/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.enjoy;

import com.jfinal.template.Directive;
import com.jfinal.template.DirectiveFactory;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.DebugUtils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;
import org.noear.solon.view.enjoy.ClassPathSourceFactory2;
import org.noear.solon.view.enjoy.EnjoyDirectiveFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnjoyRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(EnjoyRender.class);
    private static EnjoyRender _global;
    private final ClassLoader classLoader;
    private final String viewPrefix;
    private Engine provider = null;
    private Engine providerOfDebug = null;

    public static EnjoyRender global() {
        if (_global == null) {
            _global = new EnjoyRender();
        }
        return _global;
    }

    public Engine getProvider() {
        return this.provider;
    }

    public Engine getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public EnjoyRender() {
        this((ClassLoader)AppClassLoader.global(), null);
    }

    public EnjoyRender(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public EnjoyRender(ClassLoader classLoader, String viewPrefix) {
        this.classLoader = classLoader;
        this.viewPrefix = viewPrefix == null ? ViewConfig.getViewPrefix() : viewPrefix;
        Engine.setChineseExpression((boolean)true);
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void forDebug() {
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        File dir = DebugUtils.getDebugLocation((ClassLoader)this.classLoader, (String)this.viewPrefix);
        if (dir == null) {
            return;
        }
        this.providerOfDebug = Engine.create((String)"debug");
        this.providerOfDebug.setDevMode(true);
        try {
            if (dir.exists()) {
                this.providerOfDebug.setBaseTemplatePath(dir.getPath());
                this.providerOfDebug.setSourceFactory((ISourceFactory)new FileSourceFactory());
            }
            EventBus.publish((Object)this.providerOfDebug);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = Engine.use();
        this.provider.setDevMode(Solon.cfg().isDebugMode());
        try {
            if (ResourceUtil.hasFile((String)this.viewPrefix)) {
                URL dir = ResourceUtil.findResource((ClassLoader)this.classLoader, (String)this.viewPrefix, (boolean)false);
                this.provider.setBaseTemplatePath(dir.getFile());
                this.provider.setSourceFactory((ISourceFactory)new FileSourceFactory());
            } else {
                this.provider.setBaseTemplatePath(this.viewPrefix);
                this.provider.setSourceFactory((ISourceFactory)new ClassPathSourceFactory2(this.classLoader));
            }
            EventBus.publish((Object)this.provider);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putDirective(String name, Class<? extends Directive> clz) {
        try {
            this.provider.getEngineConfig().addDirective(name, clz);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.getEngineConfig().addDirective(name, clz);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putDirective(String name, EnjoyDirectiveFactory directiveFactory) {
        try {
            this.provider.getEngineConfig().addDirective(name, (DirectiveFactory)directiveFactory);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.getEngineConfig().addDirective(name, (DirectiveFactory)directiveFactory);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.addSharedObject(name, value);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.addSharedObject(name, value);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putFunction(String path) {
        try {
            this.provider.addSharedFunction(path);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.addSharedFunction(path);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "EnjoyRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate(mv.view());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(mv.view());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream.get(), ServerProps.response_encoding));
        template.render(mv.model(), (Writer)writer);
        writer.flush();
    }
}

