/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.slf4j.Logger;

public class JarHolder {
    private String urlpath = null;
    private JarFile theJar = null;
    private JarURLConnection conn = null;
    private Logger log = null;

    public JarHolder(RuntimeServices runtimeServices, String string, Logger logger) {
        this.log = logger;
        this.urlpath = string;
        this.init();
        logger.debug("JarHolder: initialized JAR: {}", (Object)string);
    }

    public void init() {
        try {
            this.log.debug("JarHolder: attempting to connect to {}", (Object)this.urlpath);
            URL uRL = new URL(this.urlpath);
            this.conn = (JarURLConnection)uRL.openConnection();
            this.conn.setAllowUserInteraction(false);
            this.conn.setDoInput(true);
            this.conn.setDoOutput(false);
            this.conn.connect();
            this.theJar = this.conn.getJarFile();
        }
        catch (IOException iOException) {
            String string = "JarHolder: error establishing connection to JAR at \"" + this.urlpath + "\"";
            this.log.error(string, iOException);
            throw new VelocityException(string, iOException);
        }
    }

    public void close() {
        try {
            this.theJar.close();
        }
        catch (Exception exception) {
            String string = "JarHolder: error closing the JAR file";
            this.log.error(string, exception);
            throw new VelocityException(string, exception);
        }
        this.theJar = null;
        this.conn = null;
        this.log.trace("JarHolder: JAR file closed");
    }

    public InputStream getResource(String string) throws ResourceNotFoundException {
        InputStream inputStream = null;
        try {
            JarEntry jarEntry = this.theJar.getJarEntry(string);
            if (jarEntry != null) {
                inputStream = this.theJar.getInputStream(jarEntry);
            }
        }
        catch (Exception exception) {
            this.log.error("JarHolder: getResource() error", exception);
            throw new ResourceNotFoundException(exception);
        }
        return inputStream;
    }

    public Hashtable getEntries() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(559);
        Enumeration<JarEntry> enumeration = this.theJar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            hashtable.put(jarEntry.getName(), this.urlpath);
        }
        return hashtable;
    }

    public String getUrlPath() {
        return this.urlpath;
    }
}

