/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.velocity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.SupplierEx;
import org.noear.solon.view.velocity.XPluginImp;

public class VelocityRender
implements XRender {
    private static VelocityRender _global;
    private VelocityEngine velocity = new VelocityEngine();
    private Map<String, Object> _sharedVariable = new HashMap<String, Object>();
    private String _baseUri = "/WEB-INF/view/";

    public static VelocityRender global() {
        if (_global == null) {
            _global = new VelocityRender();
        }
        return _global;
    }

    public VelocityRender() {
        String baseUri = XApp.cfg().get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (XApp.cfg().isDebugMode()) {
            this.forDebug();
        } else {
            this.forRelease();
        }
        this.velocity.setProperty("UTF-8", (Object)this.getEncoding());
        this.velocity.setProperty("input.encoding", (Object)this.getEncoding());
        XApp.cfg().forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith("veloci")) {
                this.velocity.setProperty(key, v);
            }
        });
        this.velocity.init();
        XApp.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.velocity.setProperty("file.resource.loader.path", (Object)(dir.getAbsolutePath() + File.separatorChar));
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        String root_path = XUtil.getResource((String)this._baseUri).getPath();
        this.velocity.setProperty("file.resource.loader.cache", (Object)true);
        this.velocity.setProperty("file.resource.loader.path", (Object)root_path);
    }

    public void loadDirective(Object obj) {
        this.velocity.loadDirective(obj.getClass().getName());
    }

    public void setSharedVariable(String key, Object obj) {
        this._sharedVariable.put(key, obj);
    }

    public String getEncoding() {
        return "utf-8";
    }

    public void render(Object obj, XContext ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, XContext ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, XContext ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "VelocityRender");
        }
        String view = mv.view();
        Template t = this.velocity.getTemplate(view, this.getEncoding());
        VelocityContext vc = new VelocityContext(mv.model());
        this._sharedVariable.forEach((k, v) -> vc.put(k, v));
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        t.merge((Context)vc, (Writer)writer);
        writer.flush();
    }
}

