/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.velocity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.directive.Directive;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.ext.SupplierEx;
import org.noear.solon.view.velocity.XPluginImp;

public class VelocityRender
implements Render {
    private static VelocityRender _global;
    private RuntimeInstance engine;
    private RuntimeInstance engine_debug;
    private Map<String, Object> _sharedVariable = new HashMap<String, Object>();
    private String _baseUri = "/WEB-INF/view/";

    public static VelocityRender global() {
        if (_global == null) {
            _global = new VelocityRender();
        }
        return _global;
    }

    public VelocityRender() {
        String baseUri = Solon.cfg().get("slon.mvc.view.prefix");
        if (!Utils.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (Solon.cfg().isDebugMode()) {
            this.forDebug();
            this.forRelease();
        } else {
            this.forRelease();
        }
        this.engineInit(this.engine);
        this.engineInit(this.engine_debug);
        Solon.global().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void engineInit(RuntimeInstance ve) {
        if (ve == null) {
            return;
        }
        ve.setProperty("UTF-8", (Object)this.getEncoding());
        ve.setProperty("resource.default_encoding", (Object)this.getEncoding());
        Solon.cfg().forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith("velocity")) {
                ve.setProperty(key, v);
            }
        });
        ve.init();
    }

    private void forDebug() {
        String dir_str;
        if (this.engine_debug != null) {
            return;
        }
        this.engine_debug = new RuntimeInstance();
        String dirroot = Utils.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.engine_debug.setProperty("resource.loader.file.path", (Object)(dir.getAbsolutePath() + File.separatorChar));
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    private void forRelease() {
        if (this.engine != null) {
            return;
        }
        this.engine = new RuntimeInstance();
        String root_path = Utils.getResource((String)this._baseUri).getPath();
        this.engine.setProperty("resource.loader.file.cache", (Object)true);
        this.engine.setProperty("resource.loader.file.path", (Object)root_path);
    }

    public <T extends Directive> void putDirective(T obj) {
        this.engine.addDirective(obj);
        if (this.engine_debug != null) {
            this.engine_debug.addDirective(obj);
        }
    }

    public void putVariable(String key, Object obj) {
        this._sharedVariable.put(key, obj);
    }

    public String getEncoding() {
        return "utf-8";
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "VelocityRender");
        }
        String view = mv.view();
        Template template = null;
        if (this.engine_debug != null) {
            try {
                template = this.engine_debug.getTemplate(view, this.getEncoding());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.engine.getTemplate(view, this.getEncoding());
        }
        VelocityContext vc = new VelocityContext(mv.model());
        this._sharedVariable.forEach((k, v) -> vc.put(k, v));
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        template.merge((org.apache.velocity.context.Context)vc, (Writer)writer);
        writer.flush();
    }
}

