/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.reactive;

import java.io.IOException;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ActionReactiveSubscriber
implements Subscriber {
    Context ctx;
    Action action;

    public ActionReactiveSubscriber(Context ctx, Action action) {
        this.ctx = ctx;
        this.action = action;
    }

    public void onSubscribe(Subscription subscription) {
        this.ctx.asyncStart(0L, null);
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Object o) {
        try {
            this.action.render(o, this.ctx);
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx);
        }
        catch (Throwable e2) {
            this.ctx.status(500);
            EventBus.pushTry((Object)e2);
        }
        finally {
            this.onComplete();
        }
    }

    public void onComplete() {
        if (this.ctx.asyncSupported()) {
            try {
                this.ctx.asyncComplete();
            }
            catch (IOException e) {
                EventBus.pushTry((Object)e);
            }
        }
    }
}

