/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.reactor;

import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberImpl
implements Subscriber {
    Context ctx;
    Action action;

    public SubscriberImpl(Context ctx, Action action) {
        this.ctx = ctx;
        this.action = action;
    }

    public void onSubscribe(Subscription subscription) {
        this.ctx.asyncStart();
        subscription.request(1L);
    }

    public void onNext(Object o) {
        try {
            this.action.render(o, this.ctx);
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx);
        }
        catch (Throwable e2) {
            EventBus.pushTry((Object)e2);
        }
    }

    public void onComplete() {
        this.ctx.asyncComplete();
    }
}

