/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.reactive;

import java.io.IOException;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReactiveSubscriber
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(ActionReactiveSubscriber.class);
    private Context ctx;
    private Action action;

    public ActionReactiveSubscriber(Context ctx, Action action) {
        this.ctx = ctx;
        this.action = action;
    }

    public void onSubscribe(Subscription subscription) {
        this.ctx.asyncStart(-1L, null);
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Object o) {
        try {
            this.action.render(o, this.ctx, true);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx, false);
        }
        catch (Throwable e2) {
            this.ctx.status(500);
            log.warn(e.getMessage(), e);
        }
        finally {
            this.onComplete();
        }
    }

    public void onComplete() {
        if (this.ctx.asyncSupported()) {
            try {
                this.ctx.asyncComplete();
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

