/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sso.impl;

import java.io.Serializable;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.web.sso.SsoStorage;

public class SsoService {
    public void login(SsoStorage storage, Context ctx, Serializable userId) {
        String userSsoKey = storage.updateUserSsoKey(userId);
        ctx.sessionSet("user_id", (Object)userId);
        ctx.sessionSet("user_sso_key", (Object)userSsoKey);
    }

    public void logout(SsoStorage storage, Serializable userId) {
        storage.removeUserSsoKey(userId);
    }

    public Serializable getLoginedUserId(Context ctx) {
        return (Serializable)ctx.session("user_id", null);
    }

    public boolean isLogined(SsoStorage storage, Context ctx) {
        Serializable userId = (Serializable)ctx.session("user_id", null);
        if (userId == null) {
            return false;
        }
        if (Solon.cfg().isDebugMode()) {
            return true;
        }
        String userSsoKey = (String)ctx.session("user_sso_key", (Object)"");
        if (Utils.isEmpty((String)userSsoKey)) {
            return false;
        }
        String userSsoKeyOfUser = storage.getUserSsoKey(userId);
        return userSsoKey.equals(userSsoKeyOfUser);
    }
}

