/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sso.impl;

import java.io.Serializable;
import org.noear.redisx.RedisClient;
import org.noear.solon.Utils;
import org.noear.solon.web.sso.SsoStorage;

public class SsoStorageOfRedis
implements SsoStorage {
    RedisClient storage;

    public SsoStorageOfRedis(RedisClient redisClient) {
        this.storage = redisClient;
    }

    @Override
    public String updateUserSsoKey(Serializable userId) {
        String storageKey = "user_sso_key:" + userId;
        String userSsoKey = Utils.guid();
        this.storage.open(ru -> ru.key(storageKey).persist().set(userSsoKey));
        return userSsoKey;
    }

    @Override
    public void removeUserSsoKey(Serializable userId) {
        String storageKey = "user_sso_key:" + userId;
        this.storage.open(ru -> ru.key(storageKey).delete());
    }

    @Override
    public String getUserSsoKey(Serializable userId) {
        String storageKey = "user_sso_key:" + userId;
        return (String)this.storage.openAndGet(ru -> ru.key(storageKey).get());
    }
}

