/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.webdav.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.web.webdav.FileInfo;
import org.noear.solon.web.webdav.FileSystem;
import org.noear.solon.web.webdav.impl.ShardingInputStream;

public class LocalFileSystem
implements FileSystem {
    private static Map<String, Long> lockMap = new ConcurrentHashMap<String, Long>();
    private String rootPath;

    public LocalFileSystem(String rootPath) {
        this.rootPath = rootPath;
    }

    private String realPath(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return this.rootPath;
        }
        return this.rootPath + "/" + path;
    }

    private FileInfo file2Info(final File file) {
        if (file != null && !file.exists()) {
            return null;
        }
        return new FileInfo(){

            @Override
            public String name() {
                return file == null ? "" : file.getName();
            }

            @Override
            public boolean isDir() {
                return file == null ? true : file.isDirectory();
            }

            @Override
            public long size() {
                return file == null ? 0L : file.length();
            }

            @Override
            public String update() {
                Date date = file == null ? new Date() : new Date(file.lastModified());
                return DateUtil.formatDateTime((Date)date);
            }

            @Override
            public String create() {
                Date date = file == null ? new Date() : new Date(file.lastModified());
                return DateUtil.formatDateTime((Date)date);
            }
        };
    }

    @Override
    public FileInfo fileInfo(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return this.file2Info(null);
        }
        path = this.realPath(path);
        File file = new File(path);
        return this.file2Info(file);
    }

    @Override
    public String fileMime(FileInfo fi) {
        return fi.isDir() ? "httpd/unix-directory" : "text/plain";
    }

    @Override
    public List<FileInfo> fileList(String path) {
        File file = new File(path = this.realPath(path));
        if (!file.exists()) {
            return null;
        }
        File[] files = file.listFiles();
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        for (File tmp : files) {
            FileInfo fi = this.file2Info(tmp);
            if (fi == null) continue;
            list.add(fi);
        }
        return list;
    }

    @Override
    public String findEtag(String path, FileInfo fi) {
        path = this.realPath(path);
        return "W/\"" + SecureUtil.md5((String)(fi.update() + path)) + "\"";
    }

    @Override
    public InputStream fileInputStream(String path, long start, long length) {
        path = this.realPath(path);
        BufferedInputStream in = FileUtil.getInputStream((String)path);
        if (length == 0L) {
            return in;
        }
        return new ShardingInputStream(in, start, length);
    }

    @Override
    public boolean putFile(String path, InputStream in) {
        path = this.realPath(path);
        FileUtil.writeFromStream((InputStream)in, (String)path);
        return true;
    }

    @Override
    public boolean del(String path) {
        if (!FileUtil.exist((String)(path = this.realPath(path)))) {
            return true;
        }
        return FileUtil.del((String)path);
    }

    @Override
    public boolean copy(String reqPath, String descPath) {
        try {
            reqPath = this.realPath(reqPath);
            descPath = this.realPath(descPath);
            File source = new File(reqPath);
            File target = new File(descPath);
            FileUtil.copy((File)source, (File)new File(target.getParent()), (boolean)true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean move(String reqPath, String descPath) {
        try {
            reqPath = this.realPath(reqPath);
            descPath = this.realPath(descPath);
            File source = new File(reqPath);
            File target = new File(descPath);
            if (StrUtil.equals((CharSequence)source.getParent(), (CharSequence)target.getParent())) {
                FileUtil.rename((File)source, (String)FileUtil.getName((String)descPath), (boolean)true);
                return true;
            }
            FileUtil.move((File)source, (File)new File(target.getParent()), (boolean)true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean mkdir(String reqPath) {
        reqPath = this.realPath(reqPath);
        File file = FileUtil.mkdir((String)reqPath);
        return FileUtil.exist((File)file);
    }

    @Override
    public String fileUrl(String reqPath) {
        return null;
    }
}

